<?php

namespace App\Models\Regras;

use App\Models\Entity\EntradaCredito;
use App\Models\Entity\Financeiro;
use App\Models\Facade\ClienteDB;
use App\Models\Facade\FinanceiroDB;
use DateInterval;
use DateTime;
use Illuminate\Support\Facades\Auth;

class FinanceiroRegras
{
    private static $proximaDataAPagar;

    public static function salvar($p)
    {
        //INSERT
        if(!$p->id) {
            $financeiro = new Financeiro();
            $financeiro->created_at = date('Y-m-d H:i:s');
            $financeiro->fk_usuario_cad = Auth::user()->id;
        } 
        
        //UPDATE
        else {
            $financeiro = Financeiro::find($p->id);            
            $financeiro->updated_at = date('Y-m-d H:i:s');
            $financeiro->fk_usuario_alt = Auth::user()->id;
        }

        $financeiro->fk_cliente = $p->id_cliente;
        $financeiro->mes_ref = $p->mes;
        $financeiro->ano_ref = $p->ano;
        $financeiro->dependentes = $p->dependentes;
        $financeiro->valor_cliente = $p->valorTitular;
        $financeiro->valor_dependentes = $p->valorDependentes;
        $financeiro->valor_desconto = 0;
        $financeiro->valor_total_cobranca = formatarMoedaDB($p->valorTotalCobranca);
        $financeiro->valor_pago = formatarMoedaDB($p->valorPago);
        $financeiro->dt_vencimento = $p->dtVencimento;
        $financeiro->dt_pagamento = $p->dtPagamento;
        $financeiro->fk_forma_pagamento = $p->formaPagamento;
        $financeiro->observacao = $p->observacao ?? '';
        $financeiro->save();

        $cliente = ClienteDB::find($p->id_cliente);

        EntradaCredito::create([
            'fk_cartao_cliente' => $cliente->fk_cartao_cliente,
            'valor' => formatarMoedaDB($p->valorPago),
            'fk_tipo_pagamento' => $p->formaPagamento,
            'observacao' => 'Mensalidade Aluno '.$p->id_cliente.' Ref. '.$p->mes.'/'.$p->ano,
            'data' => date('Y-m-d H:i:s'),
            'fk_usuario' => Auth::user()->id
        ]);

        return $financeiro;
    }

    public static function removePagamento($id_cobranca)
    {
        $financeiro = Financeiro::find($id_cobranca);
        $financeiro->delete();
    }

    public static function getProximaDataAPagar($id_cliente)
    {
        $ultimaCobranca = FinanceiroDB::getUltimaCobrancaPaga($id_cliente);

        if($ultimaCobranca) {
            $cliente = ClienteDB::find($id_cliente);

            $dataUltimoVencimento = new DateTime($ultimaCobranca->ano_ref.'-'.$ultimaCobranca->mes_ref.'-'.$cliente->dia_vencimento); //pega o dia do vencimento no cadastro do cliente
            
            static::$proximaDataAPagar = $dataUltimoVencimento->add(new DateInterval('P1M'));

            return static::$proximaDataAPagar;
        }

        return false;
    }


    public static function verificaAtraso($id_cliente)
    {
        $proximaDataAPagar = FinanceiroRegras::getProximaDataAPagar($id_cliente);

        if(!$proximaDataAPagar)
            return true;

        $dataCorrente = new DateTime(date('Y-m-d'));
        return ($proximaDataAPagar < $dataCorrente);
    }

    public static function getDiasEmAtraso()
    {
        $dataCorrente = new DateTime(date('Y-m-d'));
        $diff = $dataCorrente->diff(static::$proximaDataAPagar);
        return $diff->days;
    }

    public static function getProximaDataAPagarFormat()
    {
        return static::$proximaDataAPagar->format('d/m/Y');
    }







    public static function getValorDependentes($dependentes)
    {
        $valorDependentes = '0.00';
        
        if($dependentes > config('parque.limite_dependentes_sem_custo')) {
            $dependentesAdicionais = $dependentes - config('parque.limite_dependentes_sem_custo');
            $valorDependentes = config('parque.valor_dependente_adicional') * $dependentesAdicionais;
        }

        return $valorDependentes;
    }

    public static function getValorMensalidadeTitular($dependentes)
    {
        return ($dependentes > 0 ? config('parque.valor_mensalidade_com_dependente') : config('parque.valor_mensalidade'));
    }

    public static function getValorTotalCobranca($valorCliente, $valorDependentes)
    {
        return ($valorDependentes > 0 ? ($valorCliente + $valorDependentes) : $valorCliente);
    }

}